package test.de.laliluna.library;

import java.util.Iterator;
import java.util.List;

import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.MySQLMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.PostgreSQLSequenceMaxValueIncrementer;

import de.laliluna.library.Book;
import de.laliluna.library.LibraryDao;
import de.laliluna.library.LibraryDaoImp;

public class TestClient {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		TestClient testClient = new TestClient();
		testClient.testUsingJava();
		testClient.testUsingSpringConfig();
	}

	public void testUsingSpringConfig() {
		ClassPathResource classPathResource = new ClassPathResource(
				"spring-config.xml");
		XmlBeanFactory beanFactory = new XmlBeanFactory(classPathResource);
		LibraryDao libraryDao = (LibraryDao) beanFactory.getBean("libraryDao");
		testInsertUpdateDelete(libraryDao); 
	}

	private void testUsingJava() {
		LibraryDao libraryDao = init();
		testInsertUpdateDelete(libraryDao);
	}

	private void testInsertUpdateDelete(LibraryDao libraryDao) {
		// insert a book
		Book book = libraryDao.insertBook(new Book(null, "My life as Java bean",
				"Sebastian", null));
		System.out.println("List books:");
		List famousBooks = libraryDao.getBooks();
		for (Iterator iter = famousBooks.iterator(); iter.hasNext();) {
			Book element = (Book) iter.next();
			System.out.println("Book: " + element.getTitle() + " written by "
					+ element.getAuthor());
		}
		// update a book
		book.setTitle("My life as Java bean, edition 2");
		libraryDao.updateBook(book);
		System.out.println("List books:");
		famousBooks = libraryDao.getBooks();
		for (Iterator iter = famousBooks.iterator(); iter.hasNext();) {
			Book element = (Book) iter.next();
			System.out.println("Book: " + element.getTitle() + " written by "
					+ element.getAuthor());
		}
		// delete the book
		libraryDao.deleteBook(book);
		System.out.println("List books:");
		famousBooks = libraryDao.getBooks();
		for (Iterator iter = famousBooks.iterator(); iter.hasNext();) {
			Book element = (Book) iter.next();
			System.out.println("Book: " + element.getTitle() + " written by "
					+ element.getAuthor());
		}
	}

	private LibraryDao init() {
		JdbcTemplate jdbcTemplate = new JdbcTemplate(getDataSource());
		
		 
		 DataFieldMaxValueIncrementer incrementer = new PostgreSQLSequenceMaxValueIncrementer(
				getDataSource(), "book_id_seq");

/*		mysql code:
 *  DataFieldMaxValueIncrementer incrementer = new MySQLMaxValueIncrementer(
					getDataSource(), "book_sequence","value");
					*/
		LibraryDao libraryDao = new LibraryDaoImp();
		((LibraryDaoImp) libraryDao).setBookIncrementer(incrementer);
		((LibraryDaoImp) libraryDao).setJdbcTemplate(jdbcTemplate);
		return libraryDao;
	}

	/* mysql code
	 * private static DriverManagerDataSource getDataSource() {
		DriverManagerDataSource dataSource = new DriverManagerDataSource();
		dataSource.setDriverClassName("com.mysql.jdbc.Driver");
		dataSource.setUsername("root");
		dataSource.setPassword("r");
		dataSource.setUrl("jdbc:mysql://localhost/library");
		return dataSource;
	}*/

	private static DriverManagerDataSource getDataSource() {
		DriverManagerDataSource dataSource = new DriverManagerDataSource();
		dataSource.setDriverClassName("org.postgresql.Driver");
		dataSource.setUsername("postgres");
		dataSource.setPassword("");
		dataSource.setUrl("jdbc:postgresql://localhost/library");
		return dataSource;
	}
	
}
