package de.laliluna.library;

import java.util.List;

public interface LibraryDao {

	/**
	 * gets id generated from db and insert book in database
	 * @param book
	 * @return book with new generated id 
	 */
	public abstract Book insertBook(Book book);
	
	/**
	 * updates the book in the database
	 * @param book
	 */
	public abstract void updateBook(Book book);
	
	/**
	 * deletes book in the database
	 * @param book
	 */
	public abstract void deleteBook(Book book);

	/**
	 * loads all books from the database and puts them in a java.util.List
	 * @return list of books
	 */
	public abstract List getBooks();

}